/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.RegistrateAdvancementProvider;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateDataProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateItemTagsProvider;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.registrate.util.nullness.FieldsAreNonnullByDefault;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2474;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
@FieldsAreNonnullByDefault
public interface ProviderType<T extends RegistrateProvider> {
    public static final ProviderType<RegistrateRecipeProvider> RECIPE = ProviderType.register("recipe", (AbstractRegistrate<?> p, RegistrateDataProvider.DataInfo e) -> new RegistrateRecipeProvider((AbstractRegistrate<?>)p, e.output()));
    public static final ProviderType<RegistrateAdvancementProvider> ADVANCEMENT = ProviderType.register("advancement", (AbstractRegistrate<?> p, RegistrateDataProvider.DataInfo e) -> new RegistrateAdvancementProvider((AbstractRegistrate<?>)p, (class_7784)e.output(), e.registriesLookup()));
    public static final ProviderType<RegistrateLootTableProvider> LOOT = ProviderType.register("loot", (AbstractRegistrate<?> p, RegistrateDataProvider.DataInfo e) -> new RegistrateLootTableProvider((AbstractRegistrate<?>)p, e.output()));
    public static final ProviderType<RegistrateTagsProvider.IntrinsicImpl<class_2248>> BLOCK_TAGS = ProviderType.register("tags/block", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider.IntrinsicImpl<class_2248>((AbstractRegistrate<?>)p, (ProviderType<RegistrateTagsProvider.IntrinsicImpl<class_2248>>)type, "blocks", e.output(), (class_5321<class_2378<class_2248>>)class_7924.field_41254, e.registriesLookup(), block -> block.method_40142().method_40237()));
    public static final ProviderType<RegistrateItemTagsProvider> ITEM_TAGS = ProviderType.registerDelegate("tags/item", type -> (p, e, existing) -> new RegistrateItemTagsProvider((AbstractRegistrate<?>)p, (ProviderType<RegistrateItemTagsProvider>)type, "items", e.output(), e.registriesLookup(), ((class_2474)existing.get(BLOCK_TAGS)).method_49662(), e.helper()));
    public static final ProviderType<RegistrateTagsProvider.IntrinsicImpl<class_3611>> FLUID_TAGS = ProviderType.register("tags/fluid", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider.IntrinsicImpl<class_3611>((AbstractRegistrate<?>)p, (ProviderType<RegistrateTagsProvider.IntrinsicImpl<class_3611>>)type, "fluids", e.output(), (class_5321<class_2378<class_3611>>)class_7924.field_41270, e.registriesLookup(), fluid -> fluid.method_40178().method_40237()));
    public static final ProviderType<RegistrateTagsProvider.IntrinsicImpl<class_1299<?>>> ENTITY_TAGS = ProviderType.register("tags/entity", (ProviderType<T> type) -> (p, e) -> new RegistrateTagsProvider.IntrinsicImpl<class_1299>((AbstractRegistrate<?>)p, (ProviderType<RegistrateTagsProvider.IntrinsicImpl<class_1299>>)type, "entity_types", e.output(), (class_5321<class_2378<class_1299>>)class_7924.field_41266, e.registriesLookup(), entityType -> entityType.method_40124().method_40237()));
    public static final ProviderType<RegistrateBlockstateProvider> BLOCKSTATE = ProviderType.register("blockstate", (AbstractRegistrate<?> p, RegistrateDataProvider.DataInfo e) -> new RegistrateBlockstateProvider((AbstractRegistrate<?>)p, (class_7784)e.output(), e.helper()));
    public static final ProviderType<RegistrateItemModelProvider> ITEM_MODEL = ProviderType.register("item_model", (AbstractRegistrate<?> p, RegistrateDataProvider.DataInfo e, Map<ProviderType<?>, RegistrateProvider> existing) -> new RegistrateItemModelProvider(p, (class_7784)e.output(), ((RegistrateBlockstateProvider)existing.get(BLOCKSTATE)).getExistingFileHelper()));
    public static final ProviderType<RegistrateLangProvider> LANG = ProviderType.register("lang", (AbstractRegistrate<?> p, RegistrateDataProvider.DataInfo e) -> new RegistrateLangProvider((AbstractRegistrate<?>)p, e.output()));

    public T create(AbstractRegistrate<?> var1, RegistrateDataProvider.DataInfo var2, Map<ProviderType<?>, RegistrateProvider> var3);

    @NotNull
    public static <T extends RegistrateProvider> ProviderType<T> registerDelegate(String name, final NonNullUnaryOperator<ProviderType<T>> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(@NotNull AbstractRegistrate<?> parent, RegistrateDataProvider.DataInfo info, Map<ProviderType<?>, RegistrateProvider> existing) {
                return ((ProviderType)type.apply(this)).create(parent, info, existing);
            }
        };
        return ProviderType.register(name, ret);
    }

    @NotNull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, final NonNullFunction<ProviderType<T>, NonNullBiFunction<AbstractRegistrate<?>, RegistrateDataProvider.DataInfo, T>> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(@NotNull AbstractRegistrate<?> parent, RegistrateDataProvider.DataInfo info, Map<ProviderType<?>, RegistrateProvider> existing) {
                return (RegistrateProvider)((NonNullBiFunction)type.apply(this)).apply(parent, info);
            }
        };
        return ProviderType.register(name, ret);
    }

    @NotNull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, final NonNullBiFunction<AbstractRegistrate<?>, RegistrateDataProvider.DataInfo, T> type) {
        ProviderType ret = new ProviderType<T>(){

            @Override
            public T create(AbstractRegistrate<?> parent, RegistrateDataProvider.DataInfo info, Map<ProviderType<?>, RegistrateProvider> existing) {
                return (RegistrateProvider)type.apply(parent, info);
            }
        };
        return ProviderType.register(name, ret);
    }

    @NotNull
    public static <T extends RegistrateProvider> ProviderType<T> register(String name, ProviderType<T> type) {
        RegistrateDataProvider.TYPES.put((Object)name, type);
        return type;
    }
}

